float4x4 viewProjMatrix : register (c0);

struct VS_OUTPUT
{
   float4 Pos   : POSITION;
   float2 Tex   : TEXCOORD0;
#if FLOAT == 1
   float  Depth : TEXCOORD1;
#endif   
};

#if FLOAT == 1

 #if BUMP == 1
  VS_OUTPUT vs11_shadowDrawTexBumpFP (float4 inPos : POSITION, float2 inTex : TEXCOORD0)
 #else 
  VS_OUTPUT vs11_shadowDrawTexFP (float4 inPos : POSITION, float2 inTex : TEXCOORD0)
 #endif 

#else

 #if BUMP == 1
  VS_OUTPUT vs11_shadowDrawTexBump (float4 inPos : POSITION, float2 inTex : TEXCOORD0)
 #else 
  VS_OUTPUT vs11_shadowDrawTex (float4 inPos : POSITION, float2 inTex : TEXCOORD0)
 #endif 
 
#endif 
{
  VS_OUTPUT Out;
  
  // Transform vertex position into view space (view is the light's view):
  Out.Pos = mul (viewProjMatrix, inPos);
  Out.Tex = inTex;
  
#if FLOAT == 1
  Out.Depth = Out.Pos.z;
#endif

  return (Out);
}

